/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.event;

import com.izofar.bygonenether.init.ModConfiguredFeatures;
import com.izofar.bygonenether.init.ModConfiguredStructures;
import com.izofar.bygonenether.init.ModStructures;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ModWorldEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.NETHER) {
            event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_NETHER_FORTRESS);
            event.getGeneration().getStructures().removeIf(supplier -> ((StructureFeature)supplier.get()).field_236268_b_ == StructureFeatures.field_244149_o.field_236268_b_);
            if (ModWorldEvents.isBiome(event, Biomes.field_235252_ay_.func_240901_a_())) {
                event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CATACOMB);
                event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> ModConfiguredFeatures.SOUL_STONE_BLOBS);
            } else if (ModWorldEvents.isBiome(event, Biomes.field_235253_az_.func_240901_a_())) {
                event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_PIGLIN_MANOR);
            } else if (ModWorldEvents.isBiome(event, Biomes.field_235250_aA_.func_240901_a_())) {
                event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CITADEL);
            }
            if (ModWorldEvents.isBiome(event, Biomes.field_235251_aB_.func_240901_a_())) {
                event.getGeneration().getStructures().add(() -> StructureFeatures.field_244153_s);
            }
            if (ModWorldEvents.isLoaded("biomesoplenty") && !ModWorldEvents.isBiome(event, "biomesoplenty:crystalline_chasm") && !ModWorldEvents.isBiome(event, "biomesoplenty:undergrowth") && !ModWorldEvents.isBiome(event, "biomesoplenty:visceral_heap") && ModWorldEvents.isBiome(event, "biomesoplenty:withered_abyss")) {
                event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CATACOMB);
            }
            if (ModWorldEvents.isLoaded("cinderscapes") && !ModWorldEvents.isBiome(event, "cinderscapes:quartz_canyon") && !ModWorldEvents.isBiome(event, "cinderscapes:luminous_grove") && (ModWorldEvents.isBiome(event, "cinderscapes:ashy_shoals") || ModWorldEvents.isBiome(event, "cinderscapes:blackstone_shales"))) {
                event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CATACOMB);
                event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> ModConfiguredFeatures.SOUL_STONE_BLOBS);
            }
            if (ModWorldEvents.isLoaded("betternether")) {
                if (ModWorldEvents.isBiome(event, "betternether:bone_reef") || ModWorldEvents.isBiome(event, "betternether:nether_jungle") || ModWorldEvents.isBiome(event, "betternether:old_warped_woods") || ModWorldEvents.isBiome(event, "betternether:upside_down_forest")) {
                    event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CITADEL);
                } else if (ModWorldEvents.isBiome(event, "betternether:crimson_glowing_woods") || ModWorldEvents.isBiome(event, "betternether:crimson_pinewood")) {
                    event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_PIGLIN_MANOR);
                } else if (ModWorldEvents.isBiome(event, "betternether:flooded_deltas")) {
                    event.getGeneration().getStructures().add(() -> StructureFeatures.field_244153_s);
                } else if (ModWorldEvents.isBiome(event, "betternether:soul_plain")) {
                    event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CATACOMB);
                    event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> ModConfiguredFeatures.SOUL_STONE_BLOBS);
                } else if (ModWorldEvents.isBiome(event, "betternether:nether_grasslands") || ModWorldEvents.isBiome(event, "betternether:poor_nether_grasslands") || ModWorldEvents.isBiome(event, "betternether:wart_forest") || ModWorldEvents.isBiome(event, "betternether:wart_forest_edge")) {
                    event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> ModConfiguredFeatures.SOUL_STONE_BLOBS);
                } else if (ModWorldEvents.isBiome(event, "betternether:gravel_desert") || ModWorldEvents.isBiome(event, "betternether:magma_land") || ModWorldEvents.isBiome(event, "betternether:nether_mushroom_forest") || ModWorldEvents.isBiome(event, "betternether:nether_mushroom_forest_edge") || ModWorldEvents.isBiome(event, "betternether:nether_swampland") || ModWorldEvents.isBiome(event, "betternether:nether_swampland_terraces") || ModWorldEvents.isBiome(event, "betternether:old_fungiwoods") || ModWorldEvents.isBiome(event, "betternether:old_swampland") || ModWorldEvents.isBiome(event, "betternether:sulfuric_bone_reef")) {
                    // empty if block
                }
            }
            if (!ModWorldEvents.isLoaded("infernalexp") || ModWorldEvents.isBiome(event, "infernalexp:glowstone_canyon")) {
                // empty if block
            }
            if (ModWorldEvents.isLoaded("byg")) {
                if (ModWorldEvents.isBiome(event, "byg:waiting_garth")) {
                    event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CATACOMB);
                } else if (ModWorldEvents.isBiome(event, "byg:crimson_gardens")) {
                    event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_PIGLIN_MANOR);
                } else if (ModWorldEvents.isBiome(event, "byg:glowstone_gardens")) {
                    event.getGeneration().getStructures().add(() -> ModConfiguredStructures.CONFIGURED_CITADEL);
                }
            }
        }
    }

    private static boolean isLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    private static boolean isBiome(BiomeLoadingEvent event, String key) {
        return event.getName().toString().equals(key);
    }

    private static boolean isBiome(BiomeLoadingEvent event, ResourceLocation location) {
        return event.getName().equals((Object)location);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void addDimensionSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ChunkGenerator chunkGenerator = serverWorld.func_72863_F().func_201711_g();
            if (chunkGenerator instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(ModStructures.NETHER_FORTRESS.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.NETHER_FORTRESS.get()));
            tempMap.putIfAbsent(ModStructures.CATACOMB.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.CATACOMB.get()));
            tempMap.putIfAbsent(ModStructures.CITADEL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.CITADEL.get()));
            tempMap.putIfAbsent(ModStructures.PIGLIN_MANOR.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ModStructures.PIGLIN_MANOR.get()));
            chunkGenerator.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

